-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema compra
--

CREATE DATABASE IF NOT EXISTS compra;
USE compra;

--
-- Definition of table `compra_session_api`
--

DROP TABLE IF EXISTS `compra_session_api`;
CREATE TABLE `compra_session_api` (
  `id_compra_session_api` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(40) NOT NULL,
  `session` varchar(60) DEFAULT NULL,
  `creationDate` datetime NOT NULL,
  `dateOfExpiry` datetime NOT NULL,
  `sessionVariables` mediumtext,
  PRIMARY KEY (`id_compra_session_api`),
  UNIQUE KEY `uuid_UNIQUE` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `compra_session_api`
--

/*!40000 ALTER TABLE `compra_session_api` DISABLE KEYS */;
INSERT INTO `compra_session_api` (`id_compra_session_api`,`uuid`,`session`,`creationDate`,`dateOfExpiry`,`sessionVariables`) VALUES 
 (1,'b7fb35a6-c796-4d61-9471-41f7c25a3be0',NULL,'2024-12-05 20:16:48','2024-12-05 23:16:59','{\"dataUser\":{\"idct_usuario\":1,\"Login\":\"admin\",\"NombreyApellidos\":\"Fernando Humanes (admin)\",\"email\":\"info@fhumanes.com\",\"ct_grupo_idct_grupo\":1,\"UsuarioUltCambio\":1,\"FechaUltCambio\":\"2024-04-02 21:12:05\",\"reset_token\":null,\"reset_date\":null,\"active\":1},\"dataGroup\":{\"groupId\":2,\"Nombre\":\"Familia Humanes\",\"Administrador\":null}}');
/*!40000 ALTER TABLE `compra_session_api` ENABLE KEYS */;


--
-- Definition of table `compra_settings`
--

DROP TABLE IF EXISTS `compra_settings`;
CREATE TABLE `compra_settings` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `TYPE` int(11) DEFAULT '1',
  `NAME` mediumtext,
  `USERNAME` mediumtext,
  `COOKIE` varchar(500) DEFAULT NULL,
  `SEARCH` mediumtext,
  `TABLENAME` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `compra_settings`
--

/*!40000 ALTER TABLE `compra_settings` DISABLE KEYS */;
INSERT INTO `compra_settings` (`ID`,`TYPE`,`NAME`,`USERNAME`,`COOKIE`,`SEARCH`,`TABLENAME`) VALUES 
 (1,3,'0','admin',NULL,'[\".dummyField\"]','u_lista_compra'),
 (5,3,'2','humanes',NULL,'[\".dummyField\"]','u_lista_compra'),
 (6,3,'2','admin',NULL,'[\".dummyField\",\"foto\"]','u_lista_compra');
/*!40000 ALTER TABLE `compra_settings` ENABLE KEYS */;


--
-- Definition of table `compra_uggroups`
--

DROP TABLE IF EXISTS `compra_uggroups`;
CREATE TABLE `compra_uggroups` (
  `GroupID` int(11) NOT NULL AUTO_INCREMENT,
  `Label` varchar(300) DEFAULT NULL,
  `Provider` varchar(10) NOT NULL DEFAULT '',
  `Comment` mediumtext,
  PRIMARY KEY (`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `compra_uggroups`
--

/*!40000 ALTER TABLE `compra_uggroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `compra_uggroups` ENABLE KEYS */;


--
-- Definition of table `compra_ugmembers`
--

DROP TABLE IF EXISTS `compra_ugmembers`;
CREATE TABLE `compra_ugmembers` (
  `UserName` varchar(255) NOT NULL,
  `GroupID` int(11) NOT NULL,
  `Provider` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`UserName`,`GroupID`,`Provider`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `compra_ugmembers`
--

/*!40000 ALTER TABLE `compra_ugmembers` DISABLE KEYS */;
INSERT INTO `compra_ugmembers` (`UserName`,`GroupID`,`Provider`) VALUES 
 ('admin',-1,''),
 ('humanes',-1,'');
/*!40000 ALTER TABLE `compra_ugmembers` ENABLE KEYS */;


--
-- Definition of table `compra_ugrights`
--

DROP TABLE IF EXISTS `compra_ugrights`;
CREATE TABLE `compra_ugrights` (
  `TableName` varchar(300) NOT NULL,
  `GroupID` int(11) NOT NULL,
  `AccessMask` varchar(10) DEFAULT NULL,
  `Page` mediumtext,
  PRIMARY KEY (`TableName`(50),`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `compra_ugrights`
--

/*!40000 ALTER TABLE `compra_ugrights` DISABLE KEYS */;
INSERT INTO `compra_ugrights` (`TableName`,`GroupID`,`AccessMask`,`Page`) VALUES 
 ('ct_grupo',-1,'ADESPIM',NULL),
 ('ct_producto',-1,'ADESPIM',NULL),
 ('ct_unidad',-1,'ADESPIM',NULL),
 ('ct_usuario',-1,'ADESPIM',NULL),
 ('ct_usuario_grupo',-1,'ADESPIM',NULL),
 ('ct_usuario_grupo_search',-1,'AEDSPI',NULL),
 ('lista_compra',-1,'ADESPIM',NULL),
 ('seleccion_grupo',-2,'E',NULL),
 ('seleccion_grupo',-1,'ES',NULL),
 ('u_ct_grupo',-2,'AEDS',NULL),
 ('u_ct_grupo',-1,'AEDS',NULL),
 ('u_ct_producto',-2,'AEDS',NULL),
 ('u_ct_producto',-1,'AEDS',NULL),
 ('u_ct_usuario_grupo',-2,'AEDSPI',NULL),
 ('u_ct_usuario_grupo',-1,'AEDSPI',NULL),
 ('u_lista_compra',-2,'AEDS',NULL),
 ('u_lista_compra',-1,'AEDS',NULL),
 ('u_lista_compra2',-2,'AEDS',''),
 ('u_lista_compra2',-1,'AEDS',NULL);
/*!40000 ALTER TABLE `compra_ugrights` ENABLE KEYS */;


--
-- Definition of table `ct_grupo`
--

DROP TABLE IF EXISTS `ct_grupo`;
CREATE TABLE `ct_grupo` (
  `idct_grupo` int(11) NOT NULL AUTO_INCREMENT,
  `Nombre` varchar(50) COLLATE utf8_spanish_ci NOT NULL,
  `Descripcion` varchar(200) COLLATE utf8_spanish_ci DEFAULT NULL,
  `FechaAlta` datetime NOT NULL,
  `Administrador` int(11) NOT NULL,
  PRIMARY KEY (`idct_grupo`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

--
-- Dumping data for table `ct_grupo`
--

/*!40000 ALTER TABLE `ct_grupo` DISABLE KEYS */;
INSERT INTO `ct_grupo` (`idct_grupo`,`Nombre`,`Descripcion`,`FechaAlta`,`Administrador`) VALUES 
 (1,'Nombre de Calle y número','Mi casa','2018-05-03 00:00:00',1),
 (2,'Familia Humanes','C/ Fuente del Sol','2018-05-09 20:11:21',3),
 (5,'Fiesta de primavera','preparar barbacoa','2018-05-10 21:41:58',2),
 (10,'Ideas 3',NULL,'2024-12-01 14:00:01',1);
/*!40000 ALTER TABLE `ct_grupo` ENABLE KEYS */;


--
-- Definition of table `ct_producto`
--

DROP TABLE IF EXISTS `ct_producto`;
CREATE TABLE `ct_producto` (
  `idct_producto` int(11) NOT NULL AUTO_INCREMENT,
  `ct_grupo_idct_grupo` int(11) NOT NULL,
  `Nombre` varchar(60) COLLATE utf8_spanish_ci NOT NULL,
  `Cantidad` float DEFAULT NULL,
  `ct_unidad_idct_unidad` int(11) DEFAULT NULL,
  `Foto` varchar(1000) COLLATE utf8_spanish_ci DEFAULT NULL,
  `FechaUltCambio` datetime DEFAULT NULL,
  `UsuarioUltCambio` int(11) DEFAULT NULL,
  PRIMARY KEY (`idct_producto`),
  KEY `fk_ct_producto_ct_grupo1_idx` (`ct_grupo_idct_grupo`),
  KEY `fk_ct_producto_ct_unidad1_idx` (`ct_unidad_idct_unidad`),
  CONSTRAINT `fk_ct_producto_ct_grupo1` FOREIGN KEY (`ct_grupo_idct_grupo`) REFERENCES `ct_grupo` (`idct_grupo`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ct_producto_ct_unidad1` FOREIGN KEY (`ct_unidad_idct_unidad`) REFERENCES `ct_unidad` (`idct_unidad`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

--
-- Dumping data for table `ct_producto`
--

/*!40000 ALTER TABLE `ct_producto` DISABLE KEYS */;
INSERT INTO `ct_producto` (`idct_producto`,`ct_grupo_idct_grupo`,`Nombre`,`Cantidad`,`ct_unidad_idct_unidad`,`Foto`,`FechaUltCambio`,`UsuarioUltCambio`) VALUES 
 (2,1,'Uvas',750,3,'[{\"name\":\"..\\/Documentos\\/Compra\\/c13adae72b76986b6bacb5931ffb4f27032f46f0827f4f4346a56bf0919c1d71_a6g7oir6.jpg\",\"usrName\":\"c13adae72b76986b6bacb5931ffb4f27032f46f0827f4f4346a56bf0919c1d71 (1).jpg\",\"size\":8786,\"type\":\"image\\/jpeg\",\"thumbnail\":\"..\\/Documentos\\/Compra\\/thc13adae72b76986b6bacb5931ffb4f27032f46f0827f4f4346a56bf0919c1d71_6z5wbw6e.jpg\",\"thumbnail_type\":\"image\\/jpeg\",\"thumbnail_size\":1510,\"searchStr\":\"c13adae72b76986b6bacb5931ffb4f27032f46f0827f4f4346a56bf0919c1d71 (1).jpg,!:sStrEnd\"}]',NULL,NULL),
 (3,1,'Leche',12,1,'[{\"name\":\"..\\/Documentos\\/Compra\\/5ee58621bd72849eb3b3c7f0abe6fbe983d3a351da1471659da4898a865acddb_rn6wi2hc.jpg\",\"usrName\":\"5ee58621bd72849eb3b3c7f0abe6fbe983d3a351da1471659da4898a865acddb.jpg\",\"size\":10505,\"type\":\"image\\/jpeg\",\"thumbnail\":\"..\\/Documentos\\/Compra\\/th5ee58621bd72849eb3b3c7f0abe6fbe983d3a351da1471659da4898a865acddb_6he5ktpy.jpg\",\"thumbnail_type\":\"image\\/jpeg\",\"thumbnail_size\":1584,\"searchStr\":\"5ee58621bd72849eb3b3c7f0abe6fbe983d3a351da1471659da4898a865acddb.jpg,!:sStrEnd\"}]',NULL,NULL),
 (4,1,'Galletas',1,2,'[{\"name\":\"..\\/Documentos\\/Compra\\/5204252cb40993c22027bc9d69ab65f7047db7e1c8ff777142da6ebef9f6ddaa_11c04h1i.jpg\",\"usrName\":\"5204252cb40993c22027bc9d69ab65f7047db7e1c8ff777142da6ebef9f6ddaa.jpg\",\"size\":10696,\"type\":\"image\\/jpeg\",\"thumbnail\":\"..\\/Documentos\\/Compra\\/th5204252cb40993c22027bc9d69ab65f7047db7e1c8ff777142da6ebef9f6ddaa_dbcvyyrg.jpg\",\"thumbnail_type\":\"image\\/jpeg\",\"thumbnail_size\":1445,\"searchStr\":\"5204252cb40993c22027bc9d69ab65f7047db7e1c8ff777142da6ebef9f6ddaa.jpg,!:sStrEnd\"}]',NULL,NULL),
 (5,2,'Uvas',1,2,'[{\"name\":\"..\\/Documentos\\/Compra\\/c13adae72b76986b6bacb5931ffb4f27032f46f0827f4f4346a56bf0919c1d71_wh4wl2w3.jpg\",\"usrName\":\"c13adae72b76986b6bacb5931ffb4f27032f46f0827f4f4346a56bf0919c1d71.jpg\",\"size\":8786,\"type\":\"image\\/jpeg\",\"thumbnail\":\"..\\/Documentos\\/Compra\\/thc13adae72b76986b6bacb5931ffb4f27032f46f0827f4f4346a56bf0919c1d71_u01aswp4.jpg\",\"thumbnail_type\":\"image\\/jpeg\",\"thumbnail_size\":1510,\"searchStr\":\"c13adae72b76986b6bacb5931ffb4f27032f46f0827f4f4346a56bf0919c1d71.jpg,!:sStrEnd\"}]','2024-11-25 12:53:16',1),
 (6,5,'Café ',100,3,'[{\"name\":\"..\\/Documentos\\/Compra\\/caf___wjcdbw09_uqgyv95s.jpg\",\"usrName\":\"café_wjcdbw09.jpg\",\"size\":34123,\"type\":\"image\\/jpeg\",\"thumbnail\":\"..\\/Documentos\\/Compra\\/thcaf___wjcdbw09_0z0zn24n.jpg\",\"thumbnail_type\":\"image\\/jpeg\",\"thumbnail_size\":2172,\"searchStr\":\"café_wjcdbw09.jpg,!:sStrEnd\"}]',NULL,NULL),
 (7,5,'Portátil ',1,4,'[{\"name\":\"..\\/Documentos\\/Compra\\/20180426_210404_plaglig4.jpg\",\"usrName\":\"20180426_210404.jpg\",\"size\":8937,\"type\":\"image\\/jpeg\",\"thumbnail\":\"..\\/Documentos\\/Compra\\/th20180426_210404_wg1socpq.jpg\",\"thumbnail_type\":\"image\\/jpeg\",\"thumbnail_size\":1480,\"searchStr\":\"20180426_210404.jpg,!:sStrEnd\"}]',NULL,NULL),
 (8,1,'Plátanos',1,2,'[{\"name\":\"..\\/Documentos\\/Compra\\/image_oemljozt.jpg\",\"usrName\":\"image.jpg\",\"size\":7988,\"type\":\"image\\/jpeg\",\"thumbnail\":\"..\\/Documentos\\/Compra\\/thimage_p8611j47.jpg\",\"thumbnail_type\":\"image\\/jpeg\",\"thumbnail_size\":1299,\"searchStr\":\"image.jpg,!:sStrEnd\"}]',NULL,NULL),
 (9,2,'Tarta de manzana',1,4,'[{\"name\":\"..\\/Documentos\\/Compra\\/tarta de manzana_z36wttrm.png\",\"usrName\":\"tarta de manzana.png\",\"size\":60009,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/Documentos\\/Compra\\/thtarta de manzana_xrbb9cgk.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":7962,\"searchStr\":\"tarta de manzana.png,!:sStrEnd\"}]','2024-11-20 20:48:17',1),
 (21,1,'Jamón',250,3,'[{\"name\":\"..\\/Documentos\\/Compra\\/jamon_zrj0fhap.png\",\"usrName\":\"jamon.png\",\"size\":5443,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/Documentos\\/Compra\\/thjamon_0s3r0767.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":5487,\"searchStr\":\"jamon.png,!:sStrEnd\"}]','2018-11-17 14:42:43',1),
 (22,1,'Huevos',12,4,'[{\"name\":\"..\\/Documentos\\/Compra\\/huevos_l4exc9gb.jpg\",\"usrName\":\"huevos.jpg\",\"size\":3460,\"type\":\"image\\/jpeg\",\"thumbnail\":\"..\\/Documentos\\/Compra\\/thhuevos_0qay49tk.jpg\",\"thumbnail_type\":\"image\\/jpeg\",\"thumbnail_size\":1142,\"searchStr\":\"huevos.jpg,!:sStrEnd\"}]','2018-11-17 14:44:33',1),
 (24,2,'Leche Desnatada',6,1,'[{\"name\":\"..\\/Documentos\\/Compra\\/leche_1732473958.jpg\",\"usrName\":\"leche.jpg\",\"size\":9628,\"type\":\"image\\/jpeg\",\"thumbnail\":\"..\\/Documentos\\/Compra\\/TH_leche_1732473958.jpg\",\"thumbnail_size\":1648,\"thumbnail_type\":\"image\\/jpeg\",\"searchStr\":\"leche.jpg\"}]','2024-11-24 19:45:58',1),
 (51,2,'Buho invernal',1,4,'[{\"name\":\"..\\/Documentos\\/Compra\\/buho invernal_1732475828.jpg\",\"usrName\":\"buho invernal.jpg\",\"size\":8960,\"type\":\"image\\/jpeg\",\"thumbnail\":\"..\\/Documentos\\/Compra\\/TH_buho invernal_1732475828.jpg\",\"thumbnail_size\":1545,\"thumbnail_type\":\"image\\/jpeg\",\"searchStr\":\"buho invernal.jpg\"}]','2024-11-24 20:17:08',1);
/*!40000 ALTER TABLE `ct_producto` ENABLE KEYS */;


--
-- Definition of table `ct_unidad`
--

DROP TABLE IF EXISTS `ct_unidad`;
CREATE TABLE `ct_unidad` (
  `idct_unidad` int(11) NOT NULL AUTO_INCREMENT,
  `Titulo` varchar(50) COLLATE utf8_spanish_ci NOT NULL,
  PRIMARY KEY (`idct_unidad`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

--
-- Dumping data for table `ct_unidad`
--

/*!40000 ALTER TABLE `ct_unidad` DISABLE KEYS */;
INSERT INTO `ct_unidad` (`idct_unidad`,`Titulo`) VALUES 
 (1,'Litros'),
 (2,'Kilos'),
 (3,'Gramos'),
 (4,'Unidades');
/*!40000 ALTER TABLE `ct_unidad` ENABLE KEYS */;


--
-- Definition of table `ct_usuario`
--

DROP TABLE IF EXISTS `ct_usuario`;
CREATE TABLE `ct_usuario` (
  `idct_usuario` int(11) NOT NULL AUTO_INCREMENT,
  `Login` varchar(60) COLLATE utf8_spanish_ci NOT NULL,
  `NombreyApellidos` varchar(100) COLLATE utf8_spanish_ci NOT NULL,
  `Password` varchar(150) COLLATE utf8_spanish_ci NOT NULL,
  `email` varchar(100) COLLATE utf8_spanish_ci DEFAULT NULL,
  `ct_grupo_idct_grupo` int(11) DEFAULT NULL,
  `UsuarioUltCambio` int(11) DEFAULT NULL,
  `FechaUltCambio` datetime DEFAULT NULL,
  `reset_token` varchar(50) COLLATE utf8_spanish_ci DEFAULT NULL,
  `reset_date` datetime DEFAULT NULL,
  `active` int(11) DEFAULT NULL,
  PRIMARY KEY (`idct_usuario`),
  KEY `fk_ct_usuario_ct_grupo1_idx` (`ct_grupo_idct_grupo`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

--
-- Dumping data for table `ct_usuario`
--

/*!40000 ALTER TABLE `ct_usuario` DISABLE KEYS */;
INSERT INTO `ct_usuario` (`idct_usuario`,`Login`,`NombreyApellidos`,`Password`,`email`,`ct_grupo_idct_grupo`,`UsuarioUltCambio`,`FechaUltCambio`,`reset_token`,`reset_date`,`active`) VALUES 
 (1,'admin','Fernando Humanes (admin)','21232f297a57a5a743894a0e4a801fc3','info@fhumanes.com',1,1,'2024-04-02 21:12:05',NULL,NULL,1),
 (2,'user1','Usuario General 1','24c9e15e52afc47c225b757e7bee1f9d','fernandohumanes@gmail.com',5,1,'2024-04-02 21:13:35','',NULL,1),
 (3,'user2','Usuario general ','7e58d63b60197ceb55a1c487989a3720','user2@fhumanes.com',NULL,NULL,'2024-10-21 20:25:47',NULL,NULL,1);
/*!40000 ALTER TABLE `ct_usuario` ENABLE KEYS */;


--
-- Definition of table `ct_usuario_grupo`
--

DROP TABLE IF EXISTS `ct_usuario_grupo`;
CREATE TABLE `ct_usuario_grupo` (
  `idct_usuario_grupo` int(11) NOT NULL AUTO_INCREMENT,
  `ct_grupo_idct_grupo` int(11) NOT NULL,
  `ct_usuario_idct_usuario` int(11) NOT NULL,
  PRIMARY KEY (`idct_usuario_grupo`),
  KEY `fk_ct_usuario_grupo_ct_grupo_idx` (`ct_grupo_idct_grupo`),
  KEY `fk_ct_usuario_grupo_ct_usuario1_idx` (`ct_usuario_idct_usuario`),
  CONSTRAINT `fk_ct_usuario_grupo_ct_grupo` FOREIGN KEY (`ct_grupo_idct_grupo`) REFERENCES `ct_grupo` (`idct_grupo`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ct_usuario_grupo_ct_usuario1` FOREIGN KEY (`ct_usuario_idct_usuario`) REFERENCES `ct_usuario` (`idct_usuario`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

--
-- Dumping data for table `ct_usuario_grupo`
--

/*!40000 ALTER TABLE `ct_usuario_grupo` DISABLE KEYS */;
INSERT INTO `ct_usuario_grupo` (`idct_usuario_grupo`,`ct_grupo_idct_grupo`,`ct_usuario_idct_usuario`) VALUES 
 (1,1,1),
 (5,2,1),
 (11,5,2),
 (14,5,1),
 (33,1,2);
/*!40000 ALTER TABLE `ct_usuario_grupo` ENABLE KEYS */;


--
-- Definition of table `lista_compra`
--

DROP TABLE IF EXISTS `lista_compra`;
CREATE TABLE `lista_compra` (
  `idlista_compra` int(11) NOT NULL AUTO_INCREMENT,
  `ct_grupo_idct_grupo` int(11) NOT NULL,
  `ct_producto_idct_producto` int(11) DEFAULT NULL,
  `Cantidad` float NOT NULL,
  `ct_unidad_idct_unidad` int(11) NOT NULL,
  `FechaUltCambio` datetime DEFAULT NULL,
  `UsuarioUltCambio` int(11) DEFAULT NULL,
  `Comprado` varchar(1) COLLATE utf8_spanish_ci DEFAULT '0',
  `FechaComprado` datetime DEFAULT NULL,
  `UsuarioComprado` int(11) DEFAULT NULL,
  PRIMARY KEY (`idlista_compra`),
  KEY `fk_lista_compra_ct_grupo1_idx` (`ct_grupo_idct_grupo`),
  KEY `fk_lista_compra_ct_producto1_idx` (`ct_producto_idct_producto`),
  KEY `fk_lista_compra_ct_unidad1_idx` (`ct_unidad_idct_unidad`),
  CONSTRAINT `fk_lista_compra_ct_grupo1` FOREIGN KEY (`ct_grupo_idct_grupo`) REFERENCES `ct_grupo` (`idct_grupo`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_lista_compra_ct_producto1` FOREIGN KEY (`ct_producto_idct_producto`) REFERENCES `ct_producto` (`idct_producto`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_lista_compra_ct_unidad1` FOREIGN KEY (`ct_unidad_idct_unidad`) REFERENCES `ct_unidad` (`idct_unidad`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci;

--
-- Dumping data for table `lista_compra`
--

/*!40000 ALTER TABLE `lista_compra` DISABLE KEYS */;
INSERT INTO `lista_compra` (`idlista_compra`,`ct_grupo_idct_grupo`,`ct_producto_idct_producto`,`Cantidad`,`ct_unidad_idct_unidad`,`FechaUltCambio`,`UsuarioUltCambio`,`Comprado`,`FechaComprado`,`UsuarioComprado`) VALUES 
 (63,2,5,1,2,'2024-11-11 20:05:12',1,'1','2024-11-25 12:52:39',1),
 (68,2,9,1,4,'2024-11-11 20:05:02',1,'1','2024-12-02 21:12:50',1),
 (72,5,6,100,3,'2024-04-03 13:30:47',2,'0',NULL,NULL),
 (83,2,24,6,1,'2024-11-11 18:45:03',1,'0',NULL,NULL),
 (93,1,21,250,3,'2024-11-13 13:00:43',1,'1','2024-11-18 20:03:29',1),
 (95,1,22,12,4,'2024-11-13 13:01:23',1,'0',NULL,NULL),
 (96,1,4,1,2,'2024-11-13 13:01:38',1,'0',NULL,NULL),
 (97,1,3,12,1,'2024-11-13 13:01:56',1,'0',NULL,NULL),
 (99,1,8,1,2,'2024-11-13 13:02:31',1,'0',NULL,NULL),
 (100,1,2,750,3,'2024-11-13 13:02:38',1,'0',NULL,NULL),
 (101,2,NULL,10,4,'2024-11-20 20:43:48',1,'0',NULL,NULL),
 (103,2,51,1,4,'2024-11-23 19:22:19',1,'0',NULL,NULL),
 (104,5,7,1,4,'2024-11-28 19:29:46',1,'0',NULL,NULL);
/*!40000 ALTER TABLE `lista_compra` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
